define(['angular', 'app', 'TrackersFHIRService','AbstractWeeklyGoalsService'], function (angular, app) {
    'use strict';

    app.service('FitnessGoalsFHIRService', function (TrackersFHIRService) {
        var emptyGoalResource = {
            meta: {
                tag: [
                    {
                        'system': 'https://wiki.mobilehealth.DOMAIN.EXT/display/PGDMS/Client+Provenance+Mapping',
                        'code': 'REDACTED',
                        'display': 'VA FitHeart'
                    }
                ],
            },
            code: {coding: [{system: 'http://loinc.org',code: '55411-3',display: 'Exercise Tracking Panel'}]
            },
            extension: [
                {
                    'url': 'physical-activity-category',
                    'valueString': 'goal'
                },
                {
                    'url': 'steps',
                    'valueString': ''
                },
                {
                    'url': 'progress',
                    'valueInteger': 0
                },
                {
                    'url': 'activeFlag',
                    'valueString': 'false'
                },
                {
                    'url': 'startDate',
                    'valueString': ''
                },
                {
                    'url': 'endDate',
                    'valueString': ''
                }
            ],
            component: [

                {
                    code: {coding: [{system: 'http://loinc.org',code: '55411-3',display: 'Exercise Duration'}]},
                    valueQuantity: {unit: "minutes"},
                },
                {
                    code: {coding: [{system: 'http://loinc.org',code: '55412-1',display: 'Exercise Distance'}]},
                    valueQuantity: {unit: "miles"},
                }

            ]
        };








        return angular.extend({}, angular.copy(TrackersFHIRService), {
            code: 'http://loinc.org|55411-3',
            supportsLatest: true,


            buildResource: function (ngModel) {
                TrackersFHIRService.buildResource(ngModel);



                ngModel.component = ngModel.component.map(function (item) {
                     // convert string numbers back to regular int
                 //   item.outcome.resultReference = 'Observation/{{unique_ID}}';
                    if (item.hasOwnProperty('valueQuantity')) {
                        item.valueQuantity.value = parseInt(item.valueQuantity.value);
                    }





                    return item;
                });

                return ngModel;
            },

            createEmpty: function () {
                var emptyResource = angular.copy(emptyGoalResource);

                return angular.extend({}, TrackersFHIRService.createEmpty(), emptyResource);
            },

            transformItem: function (item) {
                TrackersFHIRService.transformItem(item);
            }
        });
    });
});